/*
 * Decompiled with CFR 0.152.
 */
package jclass.field;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import jclass.bwt.JCChoiceInterface;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.bwt.JCListEvent;
import jclass.bwt.JCTextComponent;
import jclass.bwt.JCTextCursorEvent;
import jclass.bwt.JCTextCursorListener;
import jclass.bwt.JCTextEvent;
import jclass.bwt.JCTextInterface;
import jclass.bwt.JCTextListener;
import jclass.bwt.JCTextManagerInterface;
import jclass.cell.CellEditor;
import jclass.cell.CellEditorEvent;
import jclass.cell.CellInfo;
import jclass.cell.CellRenderer;
import jclass.cell.InitialEvent;
import jclass.cell.ValidateListener;
import jclass.cell.ValidateSupport;
import jclass.field.JCCalendarPopup;
import jclass.field.JCDateValidator;
import jclass.field.JCFieldEvent;
import jclass.field.JCFieldListener;
import jclass.field.JCSpinEvent;
import jclass.field.JCSpinInterface;
import jclass.field.JCSpinListener;
import jclass.field.JCValidInfo;
import jclass.field.JCValidateInterface;
import jclass.util.JCListenerList;

public class JCField
implements Serializable {
    private static final boolean TRACE = false;
    public static final int VALID = 0;
    public static final int UNDEREDIT = 1;
    public static final int INVALID = 2;
    public static final int SHOW_INVALID = 0;
    public static final int RESTORE_DEFAULT = 1;
    public static final int RESTORE_PREVIOUS = 2;
    public static final int CLEAR_FIELD = 3;
    public static final int INCREMENT_STATIC = 0;
    public static final int INFER_INCREMENT = 1;
    public static final int AS_IS = 0;
    public static final int UPPERCASE = 1;
    public static final int LOWERCASE = 2;
    protected Color invalid_background;
    protected Color invalid_foreground;
    protected Color valid_background;
    protected Color valid_foreground;
    protected boolean select_on_enter;
    protected Object internal_value;
    protected Object edit_initial_value;
    protected Class edit_class;
    protected int list_index;
    protected Object default_value;
    protected int default_list_index;
    protected JCValidateInterface validator;
    protected Locale current;
    protected Object event_source;
    protected Component vc;
    protected JCTextInterface text;
    protected JCChoiceInterface choice;
    protected JCSpinInterface spin;
    protected CellRenderer renderer;
    protected CellEditor editor;
    protected int increment_policy = 0;
    protected int state;
    protected int invalid_policy;
    protected boolean allow_spin_keys = false;
    protected boolean beep = true;
    protected boolean internal_text_change = false;
    protected boolean has_focus = false;
    protected JCListenerList field_listeners;
    protected ValidateSupport validate_support = new ValidateSupport();
    protected Listeners listener = new Listeners();
    protected String prompt_text;
    protected Component prompt_target;
    protected boolean okay_to_beep = false;
    protected boolean allow_text_change = false;
    protected boolean is_cell_editor = false;
    protected boolean user_set_value = false;
    protected boolean select_all = false;
    private boolean is_setting_value = false;

    private void loadList() {
        if (this.validator == null) {
            return;
        }
        if (this.validator.getStringList() == null) {
            return;
        }
        if (this.choice != null) {
            this.choice.setItems(this.validator.getStringList());
        }
    }

    public void validate(AWTEvent aWTEvent) {
        if (this.validator == null) {
            return;
        }
        JCValidInfo jCValidInfo = this.validator.validate(this.internal_value);
        if (jCValidInfo.valid) {
            this.setValue(aWTEvent, jCValidInfo.value);
            this.list_index = jCValidInfo.list_index;
            this.setStateValid();
        } else {
            this.state = 2;
            this.setInvalidPolicy(this.invalid_policy);
        }
        if (this.spin != null) {
            this.spin.checkArrowButtons();
        }
    }

    private void initialize() {
        if (this.vc instanceof JCTextInterface) {
            this.text = (JCTextInterface)((Object)this.vc);
        }
        if (this.vc instanceof JCChoiceInterface) {
            this.choice = (JCChoiceInterface)((Object)this.vc);
        }
        if (this.vc instanceof JCSpinInterface) {
            this.spin = (JCSpinInterface)((Object)this.vc);
        }
        if (this.vc instanceof JCTextManagerInterface) {
            this.text = ((JCTextManagerInterface)((Object)this.vc)).getTextComponent();
        }
        if (this.text == null && this.choice == null && this.spin == null) {
            throw new ClassCastException("Visual Component does not support any Interface usable by JCField");
        }
        this.invalid_background = null;
        this.invalid_foreground = null;
        this.select_on_enter = false;
        if (this.text != null) {
            ((Component)((Object)this.text)).addFocusListener(this.listener);
            ((Component)((Object)this.text)).addKeyListener(this.listener);
        } else {
            this.vc.addFocusListener(this.listener);
            this.vc.addKeyListener(this.listener);
        }
        if (this.text != null) {
            this.text.addTextListener(this.listener);
            this.text.addTextCursorListener(this.listener);
        }
        if (this.choice != null) {
            this.choice.addItemListener(this.listener);
            this.loadList();
        }
        if (this.spin != null) {
            this.spin.addSpinListener(this.listener);
        }
        this.validate(null);
    }

    public JCField(Component component, JCValidateInterface jCValidateInterface, Object object, Object object2) {
        this.vc = component;
        this.validator = jCValidateInterface;
        this.internal_value = object;
        this.default_value = object2;
        this.event_source = component;
        this.initialize();
    }

    public void addNotify() {
        this.okay_to_beep = true;
    }

    public Color getInvalidBackground() {
        if (this.invalid_background == null) {
            if (this.text != null) {
                return ((Component)((Object)this.text)).getBackground();
            }
            return this.vc.getBackground();
        }
        return this.invalid_background;
    }

    public void setInvalidBackground(Color color) {
        this.invalid_background = color;
    }

    public Color getInvalidForeground() {
        if (this.invalid_foreground == null) {
            if (this.text != null) {
                return ((Component)((Object)this.text)).getForeground();
            }
            return this.vc.getForeground();
        }
        return this.invalid_foreground;
    }

    public void setInvalidForeground(Color color) {
        this.invalid_foreground = color;
    }

    public Color getValidBackground() {
        return this.valid_background;
    }

    public void setValidBackground(Color color) {
        this.valid_background = color;
    }

    public Color getValidForeground() {
        return this.valid_foreground;
    }

    public void setValidForeground(Color color) {
        this.valid_foreground = color;
    }

    public boolean getBeepOnInvalid() {
        return this.beep;
    }

    public void setBeepOnInvalid(boolean bl) {
        this.beep = bl;
    }

    public boolean getAllowSpinKeys() {
        return this.allow_spin_keys;
    }

    public void setAllowSpinKeys(boolean bl) {
        this.allow_spin_keys = bl;
    }

    public int getIncrementPolicy() {
        return this.increment_policy;
    }

    public void setIncrementPolicy(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("invalid incrementPolicy");
        }
        this.increment_policy = n;
    }

    public Component getPromptTarget() {
        return this.prompt_target;
    }

    public void setPromptTarget(Component component) {
        if (component instanceof Label || component instanceof JCLabel || component instanceof JCTextComponent || component instanceof TextComponent || component == null) {
            this.prompt_target = component;
            return;
        }
        throw new IllegalArgumentException("unsupported promptTarget");
    }

    public String getPromptText() {
        return this.prompt_text;
    }

    public void setPromptText(String string) {
        this.prompt_text = string;
    }

    public int getInvalidPolicy() {
        return this.invalid_policy;
    }

    public void setInvalidPolicy(int n) {
        if (this.validator == null) {
            return;
        }
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("invalid value for invalidPolicy");
        }
        this.invalid_policy = n;
        if (this.state != 2) {
            return;
        }
        switch (this.invalid_policy) {
            case 0: {
                this.setStateInvalid();
                return;
            }
            case 1: {
                this.setValue(this.default_value);
                return;
            }
            case 2: {
                this.setValue(this.internal_value);
                return;
            }
            case 3: {
                this.setText("");
                JCValidInfo jCValidInfo = this.validator.validateText("");
                if (jCValidInfo.valid) {
                    this.setStateValid();
                    return;
                }
                this.setStateInvalid();
                return;
            }
        }
    }

    public int getState() {
        return this.state;
    }

    public boolean getSelectOnEnter() {
        return this.select_on_enter;
    }

    public void setSelectOnEnter(boolean bl) {
        this.select_on_enter = bl;
    }

    public Object getValue() {
        if (this.validator == null) {
            return null;
        }
        return this.validator.copyValue(this.internal_value);
    }

    public void setAndValidateValue(Object object) {
        this.user_set_value = true;
        this.setValue(object);
        this.user_set_value = false;
    }

    public void setValue(Object object) {
        this.setValue(null, object);
    }

    public void setValue(AWTEvent aWTEvent, Object object) throws IllegalArgumentException {
        JCFieldEvent jCFieldEvent = null;
        if (this.validator == null) {
            return;
        }
        if (this.is_setting_value) {
            return;
        }
        this.is_setting_value = true;
        if (this.user_set_value && this.internal_value != object) {
            jCFieldEvent = new JCFieldEvent(this.event_source, this, this.internal_value, object, this.validator.getPickListIndex(object));
            this.validate_support.fireValueChangedBegin(jCFieldEvent);
            Enumeration enumeration = JCListenerList.elements(this.field_listeners);
            while (enumeration.hasMoreElements()) {
                JCFieldListener jCFieldListener = (JCFieldListener)enumeration.nextElement();
                jCFieldListener.valueChangedBegin(jCFieldEvent);
            }
            if (!jCFieldEvent.isValid()) {
                this.is_setting_value = false;
                throw new IllegalArgumentException();
            }
            object = jCFieldEvent.getValue();
        }
        this.internal_value = this.validator.copyValue(object);
        this.internal_text_change = true;
        int n = this.text.getCursorPosition();
        int n2 = this.text.getSelectionStart();
        int n3 = this.text.getSelectionEnd();
        int n4 = this.text.getText().length();
        if (this.has_focus && this.validator.hasEditFormat() && this.text != null && this.text.getEditable()) {
            this.setText(this.validator.formatForEdit(this.internal_value));
        } else {
            this.setText(this.validator.format(this.internal_value));
        }
        if (n4 == this.text.getText().length()) {
            if (n2 == n3 && n2 == n) {
                this.text.setCursorPosition(n);
            } else {
                this.text.select(n2, n3);
            }
        }
        this.internal_text_change = false;
        if (jCFieldEvent != null) {
            this.validate_support.fireValueChangedEnd(jCFieldEvent);
            Enumeration enumeration = JCListenerList.elements(this.field_listeners);
            while (enumeration.hasMoreElements()) {
                JCFieldListener jCFieldListener = (JCFieldListener)enumeration.nextElement();
                jCFieldListener.valueChangedEnd(jCFieldEvent);
            }
        }
        this.validate(aWTEvent);
        this.is_setting_value = false;
    }

    protected Object getDefaultValue() {
        return this.default_value;
    }

    protected void setDefaultValue(Object object) {
        this.default_value = object;
    }

    public boolean getAllowTextChange() {
        return this.allow_text_change;
    }

    protected void setText(String string) {
        if (this.text == null) {
            return;
        }
        this.allow_text_change = true;
        this.text.setText(string);
        this.allow_text_change = false;
    }

    public void addFieldListener(JCFieldListener jCFieldListener) {
        this.field_listeners = JCListenerList.add(this.field_listeners, jCFieldListener);
    }

    public void removeFieldListener(JCFieldListener jCFieldListener) {
        this.field_listeners = JCListenerList.remove(this.field_listeners, jCFieldListener);
    }

    public void addValidateListener(ValidateListener validateListener) {
        this.validate_support.addValidateListener(validateListener);
    }

    public void removeValidateListener(ValidateListener validateListener) {
        this.validate_support.removeValidateListener(validateListener);
    }

    public JCValidateInterface getValidator() {
        return this.validator;
    }

    public void setValidator(JCValidateInterface jCValidateInterface) {
        if (this.validator == jCValidateInterface) {
            return;
        }
        if (this.vc instanceof JCCalendarPopup) {
            if (jCValidateInterface instanceof JCDateValidator) {
                ((JCCalendarPopup)this.vc).cal.setHideTimeSpinner(true);
            } else {
                ((JCCalendarPopup)this.vc).cal.setHideTimeSpinner(false);
            }
        }
        if (this.validator != null && jCValidateInterface != null && this.validator.getClass() != jCValidateInterface.getClass()) {
            this.internal_value = null;
        }
        this.validator = jCValidateInterface;
        this.loadList();
        this.setValue(this.internal_value);
    }

    protected void setStateInvalid() {
        if (this.validator == null) {
            return;
        }
        if (this.state != 2) {
            JCFieldEvent jCFieldEvent = new JCFieldEvent(this.event_source, this, this.internal_value, this.internal_value, this.validator.getPickListIndex(this.internal_value), this.okay_to_beep && this.beep);
            this.validate_support.fireStateIsInvalid(jCFieldEvent);
            Enumeration enumeration = JCListenerList.elements(this.field_listeners);
            while (enumeration.hasMoreElements()) {
                JCFieldListener jCFieldListener = (JCFieldListener)enumeration.nextElement();
                jCFieldListener.stateIsInvalid(jCFieldEvent);
            }
            this.internal_value = jCFieldEvent.getValue();
            if (jCFieldEvent.getBeep()) {
                this.vc.getToolkit().beep();
            }
            if (this.text != null) {
                if (this.invalid_background != null) {
                    ((Component)((Object)this.text)).setBackground(this.invalid_background);
                }
                if (this.invalid_foreground != null) {
                    ((Component)((Object)this.text)).setForeground(this.invalid_foreground);
                }
            } else {
                if (this.invalid_background != null) {
                    this.vc.setBackground(this.invalid_background);
                }
                if (this.invalid_foreground != null) {
                    this.vc.setForeground(this.invalid_foreground);
                }
            }
            this.state = 2;
        }
    }

    protected void setStateValid() {
        if (this.state != 0) {
            if (this.text != null) {
                if (this.invalid_background != null) {
                    ((Component)((Object)this.text)).setBackground(this.valid_background);
                }
                if (this.invalid_foreground != null) {
                    ((Component)((Object)this.text)).setForeground(this.valid_foreground);
                }
            } else {
                if (this.invalid_background != null) {
                    this.vc.setBackground(this.valid_background);
                }
                if (this.invalid_foreground != null) {
                    this.vc.setForeground(this.valid_foreground);
                }
            }
        }
        this.state = 0;
    }

    protected void setStateUnderEdit() {
        if (this.state == 2) {
            if (this.text != null) {
                ((Component)((Object)this.text)).setBackground(this.valid_background);
                ((Component)((Object)this.text)).setForeground(this.valid_foreground);
            } else {
                this.vc.setBackground(this.valid_background);
                this.vc.setForeground(this.valid_foreground);
            }
        }
        this.state = 1;
    }

    public Component getComponent() {
        return this.vc;
    }

    public Object[] getPickList() {
        if (this.validator == null) {
            return null;
        }
        return this.validator.getPickList();
    }

    public void setPickList(Object[] objectArray) {
        if (this.validator == null) {
            return;
        }
        this.validator.setPickList(objectArray);
        this.loadList();
        this.validate(null);
    }

    public Object getEventSource() {
        return this.event_source;
    }

    public void setEventSource(Object object) {
        this.event_source = object;
    }

    public String[] getDisplayList() {
        if (this.validator == null) {
            return null;
        }
        return this.validator.getDisplayList();
    }

    public void setDisplayList(String[] stringArray) {
        if (this.validator == null) {
            return;
        }
        this.validator.setDisplayList(stringArray);
        this.loadList();
        this.validate(null);
    }

    public void commitEdit() {
        this.commitEdit(null);
    }

    public void commitEdit(AWTEvent aWTEvent) {
        if (this.validator == null) {
            return;
        }
        if (this.state != 1) {
            if (this.select_on_enter) {
                this.text.setSelectionStart(0);
                this.text.setSelectionEnd(this.text.getLastPosition());
            }
            return;
        }
        String string = this.text.getText();
        JCValidInfo jCValidInfo = string == null || string.length() == 0 ? this.validator.validate(null) : this.validator.validateText(this.text.getText());
        if (jCValidInfo.valid) {
            boolean bl = false;
            try {
                this.user_set_value = true;
                this.setValue(aWTEvent, jCValidInfo.value);
                this.user_set_value = false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = true;
            }
            if (bl) {
                this.setStateInvalid();
            } else {
                this.setStateValid();
            }
        } else {
            this.setStateInvalid();
            this.setInvalidPolicy(this.invalid_policy);
        }
        if (this.select_on_enter) {
            this.text.setSelectionStart(0);
            this.text.setSelectionEnd(this.text.getLastPosition());
        }
    }

    public void initialize(InitialEvent initialEvent, CellInfo cellInfo, Object object) {
        this.is_cell_editor = true;
        this.has_focus = true;
        if (this.validator == null) {
            return;
        }
        this.edit_class = cellInfo.getDataType();
        if (object != null && !this.validator.isSupported(object)) {
            object = this.validator.convertToSupported(object);
        }
        this.select_on_enter = cellInfo.getSelectAll();
        this.edit_initial_value = object;
        this.setValue(object);
    }

    public boolean isCellEditor() {
        return this.is_cell_editor;
    }

    public boolean stopCellEditing() {
        this.commitEdit();
        return this.getState() == 0;
    }

    public Object getCellEditorValue() {
        if (this.validator == null) {
            return null;
        }
        this.commitEdit();
        Object object = this.internal_value;
        if (this.edit_class != null && object != null && this.edit_class != object.getClass()) {
            object = this.validator.convertFromSupported(object, this.edit_class.getName());
        }
        return object;
    }

    public boolean isModified() {
        if (this.validator == null) {
            return true;
        }
        return this.text.getChanged() || !this.validator.compareValues(this.internal_value, this.edit_initial_value);
    }

    class Listeners
    implements JCTextListener,
    JCTextCursorListener,
    JCItemListener,
    JCSpinListener,
    FocusListener,
    KeyListener,
    Serializable {
        private final boolean TRACE = false;

        public void textValueChangeBegin(JCTextEvent jCTextEvent) {
            if (JCField.this.validator == null) {
                return;
            }
            if (JCField.this.internal_text_change) {
                return;
            }
            if (JCField.this.state != 1) {
                JCField.this.setStateUnderEdit();
            }
            if (JCField.this.validator != null) {
                JCField.this.validator.changeText(jCTextEvent);
            }
            if (!jCTextEvent.getAllowChange() && JCField.this.beep && JCField.this.okay_to_beep) {
                JCField.this.vc.getToolkit().beep();
            }
        }

        public void textValueChangeEnd(JCTextEvent jCTextEvent) {
            if (JCField.this.internal_text_change) {
                return;
            }
        }

        public void textCursorMoveBegin(JCTextCursorEvent jCTextCursorEvent) {
            if (JCField.this.validator != null) {
                JCField.this.validator.setCursor(jCTextCursorEvent);
            }
        }

        public void textCursorMoveEnd(JCTextCursorEvent jCTextCursorEvent) {
        }

        private void print_to_prompt(String string) {
            if (JCField.this.prompt_target instanceof Label) {
                ((Label)JCField.this.prompt_target).setText(string);
                return;
            }
            if (JCField.this.prompt_target instanceof JCLabel) {
                ((JCLabel)JCField.this.prompt_target).setText(string);
                return;
            }
            if (JCField.this.prompt_target instanceof TextComponent) {
                ((TextComponent)JCField.this.prompt_target).setText(string);
                return;
            }
            if (JCField.this.prompt_target instanceof JCTextComponent) {
                ((JCTextComponent)JCField.this.prompt_target).setText(string);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (JCField.this.is_cell_editor) {
                return;
            }
            JCField.this.has_focus = true;
            if (JCField.this.validator == null) {
                return;
            }
            if (JCField.this.prompt_target != null && JCField.this.prompt_text != null) {
                this.print_to_prompt(JCField.this.prompt_text);
            }
            if (JCField.this.text == null) {
                return;
            }
            if (!JCField.this.validator.hasEditFormat()) {
                return;
            }
            if (!JCField.this.text.getEditable()) {
                return;
            }
            if (JCField.this.state == 2) {
                return;
            }
            JCField.this.internal_text_change = true;
            JCField.this.setText(JCField.this.validator.formatForEdit(JCField.this.internal_value));
            JCField.this.internal_text_change = false;
            if (JCField.this.select_on_enter) {
                JCField.this.text.setSelectionStart(0);
                JCField.this.text.setSelectionEnd(JCField.this.text.getLastPosition());
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (JCField.this.is_cell_editor) {
                return;
            }
            JCField.this.has_focus = false;
            if (JCField.this.validator == null) {
                return;
            }
            if (JCField.this.prompt_target != null && JCField.this.prompt_text != null) {
                this.print_to_prompt("");
            }
            if (JCField.this.state == 1) {
                JCField.this.commitEdit(focusEvent);
                return;
            }
            if (JCField.this.state != 2 && JCField.this.validator != null && JCField.this.validator.hasEditFormat()) {
                JCField.this.setValue(JCField.this.internal_value);
            }
        }

        public void spin(JCSpinEvent jCSpinEvent) {
            Object object = null;
            if (JCField.this.validator == null) {
                return;
            }
            JCField.this.commitEdit();
            Object object2 = JCField.this.internal_value == null || !JCField.this.validator.validate((Object)JCField.this.internal_value).valid ? JCField.this.default_value : JCField.this.internal_value;
            if (JCField.this.increment_policy == 1) {
                JCField.this.validator.inferSubField(JCField.this.text);
            }
            if (jCSpinEvent.getDirection() == JCSpinEvent.SPIN_UP) {
                object = JCField.this.validator.spinUp(object2);
            } else if (jCSpinEvent.getDirection() == JCSpinEvent.SPIN_DOWN) {
                object = JCField.this.validator.spinDown(object2);
            } else {
                return;
            }
            if (object != null) {
                JCField.this.setAndValidateValue(object);
                JCField.this.setStateValid();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Object object = null;
            boolean bl = false;
            boolean bl2 = false;
            if (JCField.this.validator == null) {
                return;
            }
            if (JCField.this.text != null && JCField.this.text.getEditable()) {
                bl = true;
            }
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 37: {
                    if (!JCField.this.allow_spin_keys || bl) break;
                    if (JCField.this.increment_policy == 1) {
                        JCField.this.validator.inferSubField(JCField.this.text);
                    }
                    JCField.this.commitEdit(keyEvent);
                    object = JCField.this.validator.spinDown(JCField.this.internal_value);
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    if (!JCField.this.allow_spin_keys || bl) break;
                    if (JCField.this.increment_policy == 1) {
                        JCField.this.validator.inferSubField(JCField.this.text);
                    }
                    JCField.this.commitEdit(keyEvent);
                    object = JCField.this.validator.spinUp(JCField.this.internal_value);
                    keyEvent.consume();
                    break;
                }
                case 27: {
                    bl2 = true;
                    if (JCField.this.state != 1 && JCField.this.state != 2) break;
                    JCField.this.state = 0;
                    object = JCField.this.internal_value;
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    JCField.this.commitEdit(keyEvent);
                    keyEvent.consume();
                    return;
                }
            }
            if (object != null) {
                JCField.this.setValue(keyEvent, object);
            }
            if (bl2 && JCField.this.select_on_enter) {
                JCField.this.text.setSelectionStart(0);
                JCField.this.text.setSelectionEnd(JCField.this.text.getLastPosition());
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void itemStateChanged(JCItemEvent jCItemEvent) {
            if (jCItemEvent.getStateChange() != 1) {
                return;
            }
            if (JCField.this.validator == null) {
                return;
            }
            Object[] objectArray = JCField.this.validator.getPickList();
            int n = ((JCChoiceInterface)jCItemEvent.getSource()).getSelectedIndex();
            if (objectArray == null || n >= objectArray.length || objectArray.length <= 0) {
                throw new ArrayIndexOutOfBoundsException("pickList does not match itemList");
            }
            JCField.this.setValue(jCItemEvent, objectArray[n]);
            if (JCField.this.isCellEditor() && JCField.this.text instanceof JCTextComponent) {
                ((JCTextComponent)JCField.this.text).getCellEditorSupport().fireStopEditing(new CellEditorEvent(jCItemEvent));
            }
        }

        public void listItemSelectBegin(JCListEvent jCListEvent) {
        }

        public void listItemSelectEnd(JCListEvent jCListEvent) {
            if (!jCListEvent.getAllowSelection()) {
                return;
            }
            if (JCField.this.validator == null) {
                return;
            }
            int n = jCListEvent.getRow();
            if (n < JCField.this.validator.getPickList().length) {
                throw new ArrayIndexOutOfBoundsException("pickList does not match itemList");
            }
            JCField.this.setValue(jCListEvent, JCField.this.validator.getPickList()[n]);
        }

        Listeners() {
            JCField.this = JCField.this;
        }
    }
}

